% ANALYZES MACRO SIMULATION DATA FOLLOWING 
% FERNALD, HALL, STOCK AND WATSON 2016
% July 28, 2017

%% SET-UP
clear all 
clc
cd('C:\Users\German Gutierrez\Dropbox\0. Current research\0. QNIK_Replication\Macro_Sim')

%% DATA LOADING

% sim_zlb.csv used for paper
currData ='inputs\sim_zlb.csv';  
macroData = readtable(currData);
macroData.Properties.VariableNames = {'dy', 'dc','dn','dk','dv','dw','pinf','i','sn','y','n','k','c'};

shocks = readtable('inputs\sim_shocks.csv');
shocks.Properties.VariableNames = {'za', 'zd','zx','zq','zi'};

elasp = readtable('inputs\sim_elasp.csv');

elasp = repmat(elasp,101,1);

aData = [macroData, shocks, elasp];
 
%% USER INPUTS
% est = estimate s^N; '' = true s^N
sN_def = '';

% parameters
rho_a = 0.98;
alpha = 1/3;
bw_bw = 60;
flags = 2;
blags = 2;

% count simulations
nRows = size(aData ,1);
aData.row = (1:nRows)';
aData.simqtr = mod(aData.row,100);
aData.simN= ceil(aData.row./100);

%% ANALYSIS

% compute changes
aData.mu = aData.elasp./(aData.elasp-1);
aData.alpha_t = 1-aData.sn;
aData.tfp = exp(aData.y)./((exp(aData.k).^(1-aData.sn)).*(exp(aData.n).^aData.sn));

% data preparation: leads and lags
nSim = max(aData.simN);
aData.f2dn = NaN*zeros(nRows,1);
aData.fdn = NaN*zeros(nRows,1);
aData.l2dn = NaN*zeros(nRows,1);
aData.ldn = NaN*zeros(nRows,1);
aData.ltfp = NaN*zeros(nRows,1);
aData.lsn = NaN*zeros(nRows,1);


for i = 1:nSim
    aData.f2dn(1+100*(i-1):100*i) = [aData.dn(3+100*(i-1):100*i,1); NaN; NaN];
    aData.fdn(1+100*(i-1):100*i) = [aData.dn(2+100*(i-1):100*i,1); NaN];
    aData.ldn(1+100*(i-1):100*i) = [NaN; aData.dn(1+100*(i-1):100*i-1,1)];    
    aData.l2dn(1+100*(i-1):100*i) = [NaN; NaN; aData.dn(1+100*(i-1):100*i-2,1)];
    aData.ltfp(1+100*(i-1):100*i) = [NaN; aData.tfp(1+100*(i-1):100*i-1,1)];    
    aData.lsn(1+100*(i-1):100*i) = [NaN; aData.sn(1+100*(i-1):100*i-1,1)];    
end

aData.msn = (aData.sn + aData.lsn)/2;
aData.dtfp = aData.dy - aData.msn.*aData.dn -(1-aData.msn).*aData.dk;
aData.dyn = aData.dy - aData.dn;
aData.dky = aData.dk - aData.dy;
aData.dkn = aData.dk - aData.dn;

% series for regressions
varnames = {'y', 'tfp','k','n','yn','ky','tk','tn','ttfp','tky','dkn'};

raw_dX = [aData.dy,aData.dtfp,aData.dk,aData.dn,aData.dyn,aData.dky, ...
            aData.alpha_t.*aData.dk,(1-aData.alpha_t).*aData.dn,...
           (ones(nRows,1)./(1-aData.alpha_t)).*aData.dtfp,...
           (aData.alpha_t./(1-aData.alpha_t)).*aData.dky,aData.dkn];
       
nvars = size(raw_dX,2);

% output storage matrices
betas_store = NaN*zeros(nSim,flags + blags + 2);
sumbetas = NaN*zeros(nSim,nvars);
r2s = NaN*zeros(nSim,nvars);

c_store = NaN*zeros(nRows,nvars); % cyclical prediction
res_store = NaN*zeros(nRows,nvars); % cycle-adjusted residual
mu_store = NaN*zeros(nRows,nvars);  % trend
z_store = NaN*zeros(nRows,nvars);  % total residual

% estimate regressions and de-trended series
for i = 1:nSim
    % start and end indices
    sind = blags+1+100*(i-1);
    eind = 100*i-flags;

    % dependent var
    X = [aData.f2dn(1+100*(i-1):100*i,:), aData.fdn(1+100*(i-1):100*i,:), aData.dn(1+100*(i-1):100*i,:), aData.ldn(1+100*(i-1):100*i,:), aData.l2dn(1+100*(i-1):100*i,:)];
    j = 1;
    
    % run regressions, estimate cycle-adjusted series and filtered long-run trend 
    for j = 1:nvars 
        
        % run regression
        Y = raw_dX(sind:eind,j);
        regout = nwest(Y,[ones(size(Y,1),1), X(1+blags:100-flags,:)],0); 
        betas = regout.beta';
        pred = regout.yhat ;
        res = Y - pred;
        
        % biweight filtered trend
        mu = bw_trend(res,bw_bw); 
        
        % store output
        betas_store(i,:) = betas;
        sumbetas(i,j) = betas(1,4);
        r2s(i,j) = regout.rsqr;
        c_store(sind:eind,j) = regout.yhat;
        res_store(sind:eind,j) = res;
        mu_store(sind:eind,j) = mu; 
        z_store(sind:eind,j) = Y - pred - mu;
        
    end
end

% generate cumulated series for plots 
cum_raw = NaN*zeros(nRows,nvars);
cum_res = NaN*zeros(nRows,nvars);
cum_trend = NaN*zeros(nRows,nvars);

for i = 1:nSim
    sind = blags+1+100*(i-1);
    eind = 100*i-flags;
    cum_raw(sind:eind,:) = cumsum(raw_dX(sind:eind,:));
    cum_res(sind:eind,:) = cumsum(res_store(sind:eind,:));
    cum_trend(sind:eind,:) = cumsum(mu_store(sind:eind,:));
end
 
%% Output 1: Table

% cyclicality of real output and its components
sdBySim_pred = NaN*zeros(nSim,nvars);
sdBySim_mu = NaN*zeros(nSim,nvars);
sdBySim_z = NaN*zeros(nSim,nvars);
gap_trend = NaN*zeros(nSim,nvars);

for i = 1:nSim
    sind = blags+1+100*(i-1);
    eind = 100*i-flags;
    
    sdBySim_pred(i,:) = std(c_store(sind:eind,:));
    sdBySim_mu(i,:) = std(mu_store(sind:eind,:));
    sdBySim_z(i,:) = std(z_store(sind:eind,:));
    
    gap_trend(i,:) = cum_res(eind,:) - cum_trend(eind,:);
end

gap = cum_res - cum_trend;
sdGapByper = NaN*zeros(100,nvars);
medGapByper = NaN*zeros(100,nvars);
t = 100:100:10000;
for i = 1:100
    sdGapByper(i,:) = std(gap(t+i,:));
    medGapByper(i,:) = median(gap(t+i,:));
end
    
med_beta = median(sumbetas(2:end,:));
std_beta = std(sumbetas(2:end,:));
med_sd_pred = median(sdBySim_pred(2:end,:));
med_sd_mu = median(sdBySim_mu(2:end,:));
med_sd_z = median(sdBySim_z(2:end,:));
med_r2 = median(r2s(2:end,:));
med_gapTrend = median(gap_trend(2:end,:));
sd_gapTrend = std(gap_trend(2:end,:));


outArr = [med_beta;std_beta; med_sd_pred; med_sd_mu; med_sd_z; med_r2; med_gapTrend; sd_gapTrend];

outArr = [outArr(:,1),outArr(:,2),outArr(:,7),outArr(:,8),...
            outArr(:,5),outArr(:,9),outArr(:,10)];

outArr = outArr';
outArr = [outArr(:,1:2), 100*sqrt(4)*outArr(:,3:5), outArr(:,6:end)];        

outTable = array2table(outArr);
outTable.Properties.RowNames= {'y', 'tfp','tk','tn','yn','ttfp','tky'};
outTable.Properties.VariableNames  = {'m_b','sd_b' 'sd_c', 'sd_mu', 'sd_z', 'r2', 'med_gap', 'sd_gap'};

writetable(outTable,'outputs\15_MacroEstimates.xls','WriteRowNames',true,'sheet','SN_given')

outTable


%% Output 2: Post-crisis estimates

% create 3-D array of cumulative growth
cum_raw3D = NaN*zeros(100,nSim);
gapTFP = NaN*zeros(100,nSim);
gapKY = NaN*zeros(100,nSim);
for i = 1:nSim
 cum_raw3D(:,i)=cum_raw(1+100*(i-1):100*i,1);
 gapTFP(:,i)=gap(1+100*(i-1):100*i,2);
 gapKY(:,i)=gap(1+100*(i-1):100*i,6);
end

% find crisis = drop > 8% in output over <10 periods
nCumPer = 10;
maxCumDrop = 100*zeros(100,nSim);
for j = 2:nCumPer+1 
    maxCumDrop(j:end,:) = min(cum_raw3D(j:end,:)-cum_raw3D(1:end-j+1,:),maxCumDrop(j:end,:));
end

crisis = maxCumDrop < -0.08;
for i = 1:100
    crisis(i,:) = 0.*(sum(crisis(i+1:end,:))>0) + crisis(i,:).*(sum(crisis(i+1:end,:))==0);
end    

postcrisis = zeros(100,nSim);
nRec = 28;
for i = 1:100
    postcrisis(i,:) = 0.*(sum(crisis(max(1,i-nRec):i-1,:))==0) + 1.*(sum(crisis(max(1,i-nRec):i-1,:))==1);
end    

gapTFPpost = gapTFP.*(postcrisis==1);
gapTFPpost(gapTFPpost==0)=NaN;

gapKYpost = gapKY.*(postcrisis==1);
gapKYpost(gapKYpost==0)=NaN;


mTFP = mean(gapTFPpost,'omitnan');
mKY = mean(gapKYpost,'omitnan');

tfperr = median(mTFP,'omitnan')
pctTFPazero = sum(mTFP>0)/sum(~isnan(mTFP))

KYperr = median(mKY,'omitnan')
pctKYazero = sum(mKY>0)/sum(~isnan(mKY))



%% Some illustrative plots 

% no shocks
currSim = 1;


h = figure;
sind = blags+1+100*(currSim-1);
eind = 100*currSim-flags;
for currCol = 1:6
    subplot(2,3,currCol)
    plot(1:96,cum_raw(sind:eind,currCol), 1:96, cum_res(sind:eind,currCol), 1:96, cum_trend(sind:eind,currCol));
    title(varnames(currCol));   
end
mtit(h,'Cumulative change: No Shocks');
legend('Raw', 'Residual', 'Trend','Location','SouthWest')
saveas(h,'outputs\Cum_change_No_Shocks.eps','epsc2')


%% w shocks
currSim = 18; %18

h = figure;
sind = blags+1+100*(currSim-1);
eind = 100*currSim-flags;
for currCol = 1:6
    subplot(2,3,currCol)
    plot(1:96,cum_raw(sind:eind,currCol), 1:96, cum_res(sind:eind,currCol), 1:96, cum_trend(sind:eind,currCol));
    title(varnames(currCol));   
end
mtit(h,'Cumulative change: With Shocks');
legend('Raw', 'Residual', 'Trend','Location','SouthWest')
saveas(h,'outputs\Cum_change_W_Shocks.eps','epsc2')

%     plot(1:96,raw_dX(sind:eind,currCol),'-o', 1:96, res_store(sind:eind,currCol),'-*', 1:96, mu_store(sind:eind,currCol), '-+');
%     legend('Raw', 'Cycle-adjusted', 'Trend')
%     title(strcat('Quarterly',{' '},varnames(currCol),' change'));
%     figname = strcat('d_',varnames(currCol),'_noshocks.eps');
%     saveas(h,figname{1},'epsc2')

%%

h = figure;
plot(3:98,sdGapByper(3:98,6));
saveas(h,'outputs\SD_by_Per.eps','epsc2')

%%
currSim = 18;
sind = blags+1+100*(currSim-1);
eind = 100*currSim-flags;

figure
subplot(1,2,1)
plot(1:96,cum_raw(sind:eind,1),'-o', 1:96, cum_res(sind:eind,1),'-*', 1:96, cum_trend(sind:eind,1), '-+');
legend('Raw', 'Residual', 'Trend')
title(strcat('Cumulative',{' '}, varnames(1),' change'));

subplot(1,2,2)
plot(1:96,cum_raw(sind:eind,6),'-o', 1:96, cum_res(sind:eind,6),'-*', 1:96, cum_trend(sind:eind,6), '-+');
legend('Raw', 'Residual', 'Trend')
title(strcat('Cumulative',{' '}, varnames(6),' change'));
    
